# RentalFlow Pro - Quick Start Guide

## Welcome to RentalFlow Pro! 🎉

This guide will get you up and running in 3 minutes.

---

## Step 1: Verify Your System ✅

**Check Your Browser:**
- ✅ Chrome 90+ (recommended)
- ✅ Edge 90+
- ✅ Firefox 88+
- ❌ NOT Safari on iOS/iPad
- ❌ NOT Internet Explorer

**Check Your Device:**
- ✅ Desktop or laptop computer
- ❌ NOT mobile devices (phones/tablets)
- ❌ NOT iPhone/iPad

**Why no mobile?** This is a professional property management system designed for desktop use. Mobile devices don't have enough screen space for complex financial tracking.

---

## Step 2: Open the Application 🚀

1. **Locate the main file:**
   - Find `RentalFlow_Pro_v1.0.html` in this folder

2. **Open it:**
   - Double-click `RentalFlow_Pro_v1.0.html`
   - OR right-click → "Open With" → Chrome/Edge/Firefox

3. **Important:**
   - Keep all files in the same folder
   - Don't rename or move any files
   - The app needs `app.js`, `styles.css`, and other files to work

---

## Step 3: Activate Your License 🔐

**First Time Opening:**
1. App opens in **Demo Mode** (limited features)
2. Click **"Enter License"** button (top right)
3. Paste your license key from your purchase email
4. Click **"Activate License"**
5. Wait for confirmation (requires internet)

**After Activation:**
- All features unlocked
- No more limits
- App works offline
- Your demo data is preserved

**Don't have a license key?**
- Check your email from support@introversion.ai
- Lost it? Contact support with your order details

---

## Step 4: Start Using the App 📊

**Try These Features First:**

1. **Add a Property**
   - Click "Properties" tab
   - Click "Add Property" button
   - Fill in details (address, rent, mortgage)
   - Click "Save"

2. **Add a Tenant**
   - Click "Tenants" tab
   - Click "Add Tenant" button
   - Assign to a property
   - Set lease dates and rent

3. **Record a Transaction**
   - Click "Finances" tab
   - Click "Add Transaction" button
   - Choose Income or Expense
   - Select property and category

4. **View Reports**
   - Click "Reports" tab
   - Try "Owner Statement" or "Schedule E Tax Summary"
   - Set date range and generate

---

## Common Questions ❓

**Q: Can I use this offline?**
A: Yes! After initial activation, the app works completely offline.

**Q: Where is my data stored?**
A: Locally in your browser. Nothing is sent to external servers.

**Q: Can I backup my data?**
A: Yes! Use "Settings → Backup Data" to download a backup file.

**Q: Can I import existing data?**
A: Yes! Use the CSV templates in the `csv-templates/` folder.

**Q: Can I use this on my phone or tablet?**
A: No. This is a desktop-only application designed for professional property management.

**Q: Can I use my license on multiple devices?**
A: One device at a time. Unbind via Download Portal to move devices.

---

## Need More Help? 🆘

- **FAQ:** See `FAQ.md` for detailed questions
- **Browser Issues:** Read `BROWSER_COMPATIBILITY.md`
- **Features:** See `FEATURES.md` for complete feature list
- **Support:** Email support@introversion.ai

---

## Keyboard Shortcuts ⌨️

- **Ctrl+N** - Add new item
- **Ctrl+S** - Save form
- **Esc** - Close modal
- **1-9** - Quick tab navigation
- **F1** - Show help

---

**That's it! You're ready to manage your rental properties like a pro! 🏠**

---

*RentalFlow Pro v1.0 - Professional Property Management System*
*Visit https://rfp.introversion.ai for support and updates*
