# RentalFlow Pro v1.0 - Professional Rental Property Management

Welcome! This is your complete RentalFlow Pro package.

## 🚀 Quick Start (3 Steps)

1. **Open the App**
   - Double-click `RentalFlow_Pro_v1.0.html` to launch in your browser
   - Must use Chrome, Edge, or Firefox (NOT Safari/iOS)
   - All files must stay in this folder

2. **Activate Your License**
   - Click "Enter License" in the app
   - Paste your license key from your purchase email
   - Click "Activate" (requires internet once)

3. **Start Managing Properties**
   - Add your properties, tenants, and transactions
   - The app works offline after activation
   - Your data stays on your computer

## 📁 What's in This Package

**Main Application:**
- `RentalFlow_Pro_v1.0.html` - Main app (open this file!)
- `app.js` - Application logic (required)
- `styles.css` - Styling (required)
- `favicon.svg` - App icon

**Documentation:**
- `README.md` - This file (start here!)
- `BROWSER_COMPATIBILITY.md` - Supported browsers and devices
- `FEATURES.md` - Complete feature list
- `FAQ.md` - Common questions and troubleshooting
- `CHANGELOG.md` - Version history

**Templates & Tools:**
- `csv-templates/` - Import templates for bulk data
- `vendor/` - Required libraries (don't delete)

## ⚠️ IMPORTANT: Browser Requirements

**✅ WORKS ON:**
- Chrome/Edge on Windows, Mac, Linux (desktop/laptop only)
- Firefox 88+ on Windows, Mac, Linux (desktop/laptop only)

**❌ DOES NOT WORK ON:**
- Mobile devices (phones/tablets)
- iPhone/iPad (any browser)
- Safari on iOS
- Internet Explorer

See `BROWSER_COMPATIBILITY.md` for full details.

## 📚 Documentation Files

- **`FAQ.md`** - Common questions, activation help, troubleshooting
- **`BROWSER_COMPATIBILITY.md`** - Complete browser compatibility guide
- **`FEATURES.md`** - Full feature list and capabilities
- **`CHANGELOG.md`** - Version history and updates

## 🆘 Need Help?

1. Check `FAQ.md` for common questions
2. Read `BROWSER_COMPATIBILITY.md` if the app won't load
3. Email: support@introversion.ai
4. Website: https://rfp.introversion.ai

## 📊 Using CSV Templates

The `csv-templates/` folder contains templates for bulk importing:
- `Properties_template.csv` - Import multiple properties
- `Tenants_template.csv` - Import tenant data
- `Ledger_template.csv` - Import transactions
- `property_import_template.csv` - Comprehensive property import

## 💾 Your Data is Private

All data is stored locally in your browser. Nothing is sent to external servers except during license activation. The app works completely offline after activation.

## ⚠️ CRITICAL: Back Up Your Data Regularly

**Your data is stored in your browser's local storage. It will be PERMANENTLY LOST if you:**
- Clear your browser history/cache
- Uninstall/reinstall your browser
- Reset browser settings
- Switch to a different browser
- Reinstall your operating system

**🛡️ PROTECT YOUR DATA:**
1. **Export backups regularly** (weekly or monthly recommended)
2. Go to **Settings → Export All Data** to download a JSON backup file
3. Store backups in a safe location:
   - Cloud storage (Dropbox, Google Drive, OneDrive)
   - External USB drive
   - Multiple locations for critical data
4. **Before clearing browser data, ALWAYS export first!**

**Recovery:** If you lose your data, import your latest backup file via Settings → Import Data.

## 🔐 License Information

- One license per device (bound via device ID for security)
- Move to new device via Download Portal: https://rfp.introversion.ai/portal
- Unbind allowed once every 30 days
- Lost your license key? Check your email or contact support

**Privacy Note:** During activation, a device ID is created from your browser/system info to bind your license. No personal data or property information is collected. All your rental data stays local on your computer.

---

**RentalFlow Pro v1.0** - Professional Property Management System
© 2025 Introversion AI - All Rights Reserved
