RENTALFLOW PRO - BROWSER COMPATIBILITY GUIDE
=============================================

⚠️ CRITICAL: iOS DEVICES NOT SUPPORTED ⚠️
------------------------------------------

This application DOES NOT WORK on:
❌ iPhone (any model)
❌ iPad (any model)  
❌ iPod Touch
❌ Safari on iOS
❌ Chrome on iOS
❌ ANY browser on iOS/iPadOS

Why iOS Doesn't Work:
- Apple's iOS has severe JavaScript restrictions
- localStorage is limited/blocked
- File operations are restricted
- Cross-origin requests fail
- Progressive Web App features don't work
- Data export/import is blocked

SUPPORTED PLATFORMS
-------------------

✅ MINIMUM REQUIREMENTS (Technical Minimum):
• Google Chrome 80+ on Windows/Mac/Linux (desktop/laptop only)
• Microsoft Edge 80+ (Chromium) on Windows/Mac (desktop/laptop only)
• Firefox 74+ on Windows/Mac/Linux (desktop/laptop only)
• Safari 13.1+ on macOS desktop (limited support, some features may not work)

Note: These minimum versions support ES2020 features (optional chaining, nullish coalescing).

✅ RECOMMENDED (Best Performance):
• Google Chrome 90+ on Windows/Mac/Linux (desktop/laptop only)
• Microsoft Edge 90+ (Chromium) on Windows/Mac (desktop/laptop only)
• Firefox 88+ on Windows/Mac/Linux (desktop/laptop only)

✅ ALSO WORKS:
• Brave Browser on desktop (Chromium-based, version 80+)
• Opera on desktop (Chromium-based, version 67+)
• Chromebook (Chrome OS with Chrome 80+)

⚠️ LIMITED SUPPORT:
• Safari on Mac desktop (requires 13.1+ for ES2020 features)

❌ NOT SUPPORTED:
• Internet Explorer 11 and older (lacks modern JavaScript support)
• Old Edge Legacy (pre-Chromium, before version 80)
• Safari versions below 13.1

SYSTEM REQUIREMENTS
-------------------

Minimum Requirements:
• Modern browser (Chrome 80+, Edge 80+, Firefox 74+, or Safari 13.1+)
• 4GB RAM recommended
• Stable internet for activation (works offline after)
• Desktop or laptop computer (NOT mobile/tablet)

Recommended Setup:
• Google Chrome (latest version)
• Windows 10/11, macOS 10.14+, or Ubuntu 20.04+
• 8GB+ RAM for large datasets
• 1920x1080 or higher resolution

TROUBLESHOOTING
---------------

"App won't load on my device"
→ Check you're not on iOS
→ Use Chrome, Edge, or Firefox on desktop/laptop
→ Clear browser cache

"I only have an iPad"
→ You'll need access to a desktop or laptop computer
→ Consider using a library/work computer
→ Chromebooks work and are affordable

"Can I use my phone or tablet?"
→ Mobile devices are NOT supported (including Android)
→ This is a desktop/laptop-only application
→ Requires larger screen for professional property management

CUSTOMER NOTICE
---------------

If you purchased this app and only have mobile devices:
1. The app requires Chrome/Edge/Firefox on desktop/laptop
2. Consider using a friend's computer to set up
3. Data can be exported as CSV for use elsewhere
4. Contact support@introversion.ai for refund if needed

IMPORTANT:
Mobile devices (phones/tablets) are NOT supported due to screen size and platform limitations.
Visit https://rfp.introversion.ai for full system requirements before purchasing.

TECHNICAL DETAILS (for developers)
-----------------------------------

iOS Restrictions that break the app:
1. localStorage quota (5-10MB limit, often cleared)
2. No real file system access
3. Blob URLs are restricted
4. Service Workers heavily limited
5. Cross-origin fetch() blocked in many cases
6. JavaScript execution limits
7. No persistent storage guarantees
8. Safari WebKit bugs with modern JS features

The app uses:
- localStorage for data persistence
- Blob/File APIs for import/export
- fetch() for license validation
- Modern ES2020 JavaScript features (optional chaining, nullish coalescing)
- TextEncoder/TextDecoder for data processing
- crypto.subtle for license validation
- DOM manipulation for dynamic UI

Browser Version Requirements (Technical):
- Optional chaining (?.) - Chrome 80+, Firefox 74+, Safari 13.1+, Edge 80+
- Nullish coalescing (??) - Chrome 80+, Firefox 72+, Safari 13.1+, Edge 80+
- TextEncoder - Chrome 38+, Firefox 19+, Safari 10.1+, Edge 79+
- crypto.subtle - Chrome 37+, Firefox 34+, Safari 11+, Edge 79+

All of these are problematic on iOS Safari and not available in Internet Explorer.

---
Version: 1.0
Last Updated: 2025-11-05
Status: iOS will NEVER be supported due to platform limitations